# should be executed with 
# function fake_dungeon:pattern_generator/generate_pattern with storage fake_dungeon:generate_pattern

# Fake Dungeon floor pattern rules:
# - 100% chance for 1st item room and 40% for 2nd,
# - 65% chance for mini boss room / hard part of floors,
# - 90% chance for 1st sacrifice/challenge room and 30% chance for 2nd,
# - both of this two rooms with have 40% chance to be sacrifice room and 60% challenge room,
# - 85% chance for shop room,
# - 100% chance for 1st secret room 40% chance for 2nd secret room and 10% chance for 3rd secret room,
# - 10% chance for super secret room,
# - always 1 boss room entrance and 1 workshop,
# - miniboss room need to spawn in hard part of floor,
# - secret room / super secret room cannot spawn next to shop, workshop and boss entrance
# - 

# kill them all
execute as @e[tag=fake_dungeon.pattern_generator.start_room] run kill @s
execute as @e[tag=fake_dungeon.pattern_generator.check_next_generation] run kill @s 
execute as @e[tag=fake_dungeon.pattern_generator.check_hard_room] run kill @s
execute as @e[tag=fake_dungeon.pattern_generator.connections_counter] run kill @s
execute as @e[tag=fake_dungeon.pattern_generator.secret_room] run kill @s

# spawn place to generate pattern
place template fake_dungeon:pattern_generator_place 52 84 18 none none

# create fake_dungeon.pattern_generator.room_painter if necessary
$execute unless entity @e[tag=fake_dungeon.pattern_generator.room_painter] run summon armor_stand $(CenterX) $(CenterY) $(CenterZ) {Tags:["fake_dungeon.pattern_generator.room_painter"],CustomName:'{"text":"room_painter"}',NoGravity:true,Invulnerable:true,Silent:true}

# determinate how many special rooms should be on the floor. If not enough space, generate now floor
execute if score know_how_many_special_rooms fake_dungeon.pattern_generator matches 0 run function fake_dungeon:pattern_generator/count_how_many_special_rooms

# spread room painter and repeat till is on good position
$spreadplayers $(CenterX) $(CenterZ) 0 $(Radius) false @e[tag=fake_dungeon.pattern_generator.room_painter,limit=1,sort=nearest]
execute at @e[tag=fake_dungeon.pattern_generator.room_painter,limit=1,sort=nearest] if block ~ ~-1 ~ #fake_dungeon:rooms/pattern_border run return run function fake_dungeon:pattern_generator/generate_pattern with storage fake_dungeon:pattern_generator/generate_pattern

# copy old pattern for testing purpuses
clone 56 86 22 68 86 34 56 83 23

# clear space for new pattern
$execute as @e[tag=fake_dungeon.pattern_generator.room_painter,limit=1,sort=nearest] at @s run tp @s ~ $(CenterY) ~
clone 56 85 22 68 85 34 56 86 22
fill 56 86 22 68 86 34 air replace minecraft:white_concrete

# generate start room and reset all necessary variables
execute at @e[tag=fake_dungeon.pattern_generator.room_painter,limit=1,sort=nearest] run setblock ~ ~ ~ light_blue_wool
scoreboard players set room_count fake_dungeon.pattern_generator 1
scoreboard players set hardroom_count fake_dungeon.pattern_generator 0
scoreboard players set room_children_generation fake_dungeon.pattern_generator 0
scoreboard players set room_distance_from_spawn fake_dungeon.pattern_generator 1

# this variable starts generating next room generations
scoreboard players set generating_pattern fake_dungeon.pattern_generator 1
scoreboard players set pattern_generated fake_dungeon.game_conditions 0

# generate rooms around start room
execute as @e[tag=fake_dungeon.pattern_generator.room_painter,limit=1,sort=nearest] at @s run function fake_dungeon:pattern_generator/generate_start_rooms